import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Group {
        //setup default textures
        TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
        TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
        Texture { textureUnit: 3; textureRT: "prev" }
        Texture { textureUnit: 4; textureRT: "prevBlur" }
        Texture { textureUnit: 5; textureRT: "prevNormal" }
    }

    // clear RGB & Z here so we are sure it happens at least once properly...
    DrawMesh {
        file: "mesh/tri.lwo"; Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0; }
        Sca { s: 0.0; }
    }

    Group {
        // background ball with smokey etc textures
        id: bgBall
        name: "bgBall"
        enabled: sync("bgBall.ON")
        Shader { file: sceneDir+"smBg" }
        TextureSel { textureUnit: 0; name: parent.name }
        DrawMesh {
            file: "mesh/ball5000.x";
            enabled: true; smoothNormals: true; normalSmoothAngle: 20;
            blendMode: blendSel(bgBall.name)
            depthTest: true; depthWrite: true;
            //  cull: true; cullBack: true
            Sca { s: 400.0; x: 1.0; y: 10.0; z: 1.0 }
            Pos { x: 0.0; y: -0.005; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvOfsY"; paramValue: sync("bg.uvOfsY") }
            ShaderParam { paramName: "g_bump"; paramValue: 0.650}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: sync("bg.bright")}
        }
        Blit {  textureRT: "bgBall" }
    }



    Group {
        // big mirror plane
        id: mirrorPlane
        name: "mirrorPlane"
        enabled: sync(name+".ON"); Shader { file: "smInfiFade" }
        TextureSelFade { id: mirrorPlaneTex; textureUnit: 0; textureUnitB: 6; name: parent.name }
        VariClock {
            id: mirrorPlaneClock
            clockSpeed: sync("transGinkku.zoomPercent")
            reset: sync("transGinkku.reset")
            resetTime: sync("transGinkku.resetTime")
        }

        DrawMesh {
            file: "mesh/box1m.lwo"; enabled: true; smoothNormals: true; normalSmoothAngle: 20;
            blendMode: blendSel(mirrorPlane.name)
            depthTest: true; depthWrite: true; cull: true; cullBack: true;
            Pos { x: 0.0; y: sync("mirrorPlane.y"); z: 0.0}
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: sync(mirrorPlane.name+".uvScale")}
            ShaderParam { paramName: "g_texBrightness"; paramValue:sync(mirrorPlane.name+".bright")}
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0}
            ShaderParam { paramName: "g_bump"; paramValue: sync(mirrorPlane.name+".bump")}
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_alpha"; paramValue: sync(mirrorPlane.name+".alpha")}
            ShaderParam { paramName: "g_zoomTime"; paramValue: mirrorPlaneClock.time*0.3 }
            ShaderParam { paramName: "g_texFade0"; paramValue: mirrorPlaneTex.texFade }
            ShaderParam { paramName: "g_tex0Ofs"; paramValue: sync(mirrorPlane.name+".tex0Ofs") }
            ShaderParam { paramName: "g_tex1Ofs"; paramValue: sync(mirrorPlane.name+".tex1Ofs") }
        }
    }


    SurfNet {
        surfPotShader: "surfPot";
        surfGeomShader: "surfGeom";
        surfGridDim3DSqrt: 10;
        textureFile: "../../images/aalto.png"
    }

    Group {
        // mirror ball
        id: mirrorBall
        name: "ball"
        enabled: sync("ball.ON");
        Shader { file: sceneDir+"smVoro" }
        TextureSel { textureUnit: 0; name: parent.name }
        TextureSel { textureUnit: 1; name: parent.name }
        DrawMesh {
            property int meshSel: sync(mirrorBall.name+".meshIndex")
            file: {
                if (meshSel === 0) return "mesh/lollo.obj";
                if (meshSel === 1) return "mesh/tri.lwo";
                return "mesh/octa.lwo";
            }
            enabled: true;
            smoothNormals: true; normalSmoothAngle: 20;
            blendMode: blendSel(mirrorBall.name)
            depthTest: true; depthWrite: true;
            Pos { x: sync("ball.x"); y: sync("ball.y"); z: sync("ball.z")}
            Rot { d: sync(mirrorBall.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: sync(mirrorBall.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
            Sca { s: 28.0*sync("ball.scale"); x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 4.0}
            ShaderParam { paramName: "g_bump"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: sync("ball.bright") }
            ShaderParam { paramName: "g_alpha"; paramValue: sync(mirrorBall.name+".alpha") }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")*sync("ball.prevBlurAmount") }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScaleVoro"; paramValue: sync("ball.voroUvScale")}
            ShaderParam { paramName: "g_uvScaleYVoro"; paramValue: sync("ball.voroUvScaleY")}
            ShaderParam { paramName: "g_voroUvOfsX"; paramValue: sync("ball.voroUvOfsX")}
            ShaderParam { paramName: "g_voroUvOfsY"; paramValue: sync("ball.voroUvOfsY")}
            ShaderParam { paramName: "g_voroLift"; paramValue: sync("ball.voroLift")}
            ShaderParam { paramName: "g_distToZW"; paramValue: sync("ball.voroDistToZW")}
            ShaderParam { paramName: "g_distToZPow"; paramValue: sync("ball.voroDistToZPow")}
            ShaderParam { paramName: "g_voroDispYM"; paramValue: sync("ball.voroDispYM")}
            ShaderParam { paramName: "g_voroDispYOfs"; paramValue: sync("ball.voroDispYOfs")}
            ShaderParam { paramName: "g_genUV"; paramValue: sync("ball.genUVs")}
            SavePoint {
                target: "centrum"
                x: 0.0; y: 0.0; z: 0.0;
            }
        }
    }

    BreakMesh {
        name: "box"
    }
    BreakMesh {
        name: "box2"
    }


    Text3D {
        name: "text"
        text: "zoomin"
    }


    Group {
        // inner mirror ball
        id: innerBall
        name: "innerBall"
        enabled: sync(name+".ON"); Shader { file: sceneDir+"smPlastic" }
        TextureSel { textureUnit: 0; name: parent.name }
        DrawMesh {
            file: "mesh/ball5000.x"; enabled: true; smoothNormals: true; normalSmoothAngle: 20;
            blendMode: blendSel(innerBall.name)
            depthTest: true; depthWrite: true;
            Pos { x: 0.0; y: sync("innerBall.y"); z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 32.0*sync("innerBall.scale"); x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 4.0}
            ShaderParam { paramName: "g_bump"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: sync("innerBall.Brightness")}
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            SavePoint {
                target: "centrum"
                x: 0.0; y: 0.0; z: 0.0;
            }
        }
    }

    DrawTrans {
        id: drawTrans;
        name: "transGinkku";
        enabled: sync(name+".ON")
        emitIntervalMS: sync(name+".emitRateMS");
        file: (drawTrans.drawIndex%10 < 9) ? "mesh/boxtaper.obj" : "mesh/ball5000.x";
        // transShader contains both emit & advance code
        transShader: "zoomTrans"; drawShader: "zoomDraw"; shaderVaryings: "vec3 posG; vec3 normalG; vec2 uvG; vec3 tangentG; float brightG; vec3 origCenterG;";
        zoomPercent: 1.0*sync("transGinkku.zoomPercent");
        drawTexUvScale: 1.0;

        // because of visibility for the params, this has to be declared also here to work properly....
        TextureSelFade { id: ginkkuTexSel; textureUnit: 0; textureUnitB: 1; name: drawTrans.name; }
        drawTexture: TextureSelFade { textureUnit: 0; textureUnitB: 1; name: drawTrans.name; }

        drawParams: ParamGroup {
            Pos { x: 0.0; y: 0.0; z: 0.0 }
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_texFade"; paramValue: ginkkuTexSel.texFade; }

        }

        drawMesh: DrawMesh {
            // draw one bigger mesh
            file: drawTrans.file;
            Pos { x: drawTrans.er*Math.sin(drawTrans.ki)+drawTrans.pr*Math.cos(drawTrans.kii*2.3); y: 0.0+Math.abs(0.0*(Math.sin(drawTrans.ki*0.9+Math.cos(drawTrans.kii*1.5)))); z: drawTrans.er*Math.cos(drawTrans.ki)+drawTrans.pr*Math.sin(drawTrans.kii*3.43)}
            Rot { d: demoTime()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }
            Sca { s: drawTrans.drawIndex%20 < 19 ? 0.03 : 0.050; x: 1.0; y: 1.0; z: 1.0 }
            Pos { y: 0.50 }
            ShaderParam { paramName: "g_emit"; paramValue: 1.0}
            // high bright is teh light!
            ShaderParam { paramName: "g_bright"; paramValue: drawTrans.drawIndex%20 < 19 ? 1.01 : 100.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
            blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true;
            onRendered: { childMeshi.triggerRenderOnce();}
            // draw one smaller mesh also
            DrawMesh {
                id: childMeshi; file: (drawTrans.drawIndex%10 < 9) ? "mesh/box1m.lwo" : "mesh/ball5000.x";
                // file: "mesh/dode.lwo"
                // file: "mesh/toroid.lwo"
                // file: "mesh/rinkula.obj"
                Pos { x: drawTrans.er*Math.sin(drawTrans.ki)+drawTrans.pr*Math.cos(drawTrans.kii*2.3); y: -0.005+Math.abs(0.0*(Math.sin(drawTrans.ki*0.9+Math.cos(drawTrans.ki*1.5)))); z: drawTrans.er*Math.cos(drawTrans.ki)+drawTrans.pr*Math.sin(drawTrans.kii*3.43)}
                Rot { d: demoTime()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }
                Sca { s: 0.010; x: 1.0; y: 1.0; z: 1.0 }
                Pos { y: 1.0 }
                ShaderParam { paramName: "g_emit"; paramValue: 1.0}
                ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
                ShaderParam { paramName: "g_bright"; paramValue: 2.0}
                blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true
            }
        }
    }

    Group {
        id: boxGrower
        name: "boxGrower"
        enabled: sync(boxGrower.name+".ON")

        // diffuse texture
        // TextureImage { textureUnit: 0; file: "../../images/apo69.png"}
        TextureSelFade { id: boxGrowerTex0; textureUnit: 0; textureUnitB: 6; name: parent.name }

        // from root to leaves emit time based swipe palette triggered with swipe.trigger track
        TextureSel { textureUnit: 1; name: parent.name }
        //TextureImage { textureUnit: 1; file: "../../images/palette_shot8.png"}

        // time since birth / age based swiper palette
        TextureSel { textureUnit: 2; name: parent.name }
        //TextureImage { textureUnit: 2; file: "../../images/palette_shot1.png"}

        // palette gradient defining the grow "plane" (if one of the moveX, Y or Z is set to zero or near zero).
        // Applied with amplitude .grow.movePalAmp and the x offset in palette image is moved in time with
        // .grow.movePalFreq, .grow.movePalFreqPlane, .grow.movePalOfs, .grow.movePalOfsPlane,
        // .grow.movePalAge (how the age of the box effects the palette offset).
        // The effect for move X, Y and Z is achieved through swizzle of the moveX, moveY & moveZ in following way:
        // (all values from green channel)
        //  if palette 0.0 >= .g < 0.333 then moveXYZ (XY plane)
        //  if palette 0.333 >= .g < 0.667 then moveZXY (XZ plane)
        //  if palette 0.667 >= .g <= 1.0 then moveYZX (YZ plane)
        TextureSel { textureUnit: 3; name: parent.name }
        // TextureImage { textureUnit: 3; file: "../../images/palette_shot5.png"}

        VariClock {
            id: boxGrowerSwipeTime
            clockSpeed: sync(boxGrower.name+".swipe.speed")
            reset: sync(boxGrower.name+".swipeSpeed.reset")
            triggerReset: sync(boxGrower.name+".swipeFade.trigger")
            resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
        }


        VariClock {
            id: boxGrowerSwipeFadeTime
            clockSpeed: sync(boxGrower.name+".swipe.fadeSpeed")
            reset: sync(boxGrower.name+".swipeSpeed.reset")
            triggerReset: sync(boxGrower.name+".swipeFade.trigger")
            resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
        }

        Trigger {
            id: boxSwipeFadeTrigger
            reset: sync(boxGrower.name+".swipeFade.trigger")
        }

        DrawTrans2 {
            id: drawTransBG; name: "grow"; emitIntervalMS: sync(boxGrower.name+".emitNewInterval");
            file: "mesh/tri4.lwo";
            // file: "mesh/dode.lwo";
            // file: "mesh/boxcut.lwo";
            // file: "mesh/adapt.obj";
            // file: "mesh/plane.x"
            //  file: "mesh/ball.lwo";

            syncBaseName: boxGrower.name

            transPack: true
            shaderVaryings: "uvec2 positionGI; uvec2 normalGI; uint uvGI; uvec2 tangentGI; uvec2 origCenterGI; uvec2 genInfoGI; uvec2 emitInfoGI; uvec2 branchInfoGI;"
            zoomPercent: 1.0*sync(boxGrower.name+".zoomSpeed");
            drawBlendMode: blendSel(boxGrower.name)

            // transShader contains both emit & advance code


            transShader: "branchTransInt";
            transParams: ParamGroup {
                ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen") }
                ShaderParam { paramName: "g_maxDist"; paramValue: sync(boxGrower.name+".grow.maxDist") }
                ShaderParam { paramName: "g_branchRateMS"; paramValue: sync(boxGrower.name+".grow.branchRateMS") }
                ShaderParam { paramName: "g_branchRateVar"; paramValue: sync(boxGrower.name+".grow.branchRateVar") }
                ShaderParam { paramName: "g_branchRateVFreq"; paramValue: sync(boxGrower.name+".grow.branchRateVFreq") }
                ShaderParam { paramName: "g_branchMax"; paramValue: sync(boxGrower.name+".grow.maxBranch") }
                ShaderParam { paramName: "g_maxLevel"; paramValue: sync(boxGrower.name+".grow.maxLevel") }
                ShaderParam { paramName: "g_maxAge"; paramValue: sync(boxGrower.name+".grow.maxAgeSec") }
                ShaderParam { paramName: "g_maxEmitTime"; paramValue: sync(boxGrower.name+".grow.maxEmitTimeSec") }
                ShaderParam { paramName: "g_branchMoveFreq"; paramValue: sync(boxGrower.name+".grow.moveFreq") }
                ShaderParam { paramName: "g_branchMoveFreqVar"; paramValue: sync(boxGrower.name+".grow.moveFreqVar") }
                ShaderParam { paramName: "g_branchGrowScale"; paramValue: sync(boxGrower.name+".grow.sca") }
                ShaderParam { paramName: "g_branchGrowScaleVar"; paramValue: sync(boxGrower.name+".grow.scaVar") }
                ShaderParam { paramName: "g_branchGrowScaleVarFreq"; paramValue: sync(boxGrower.name+".grow.scaVarFreq") }
                ShaderParam { paramName: "g_branchGrowScaleVarPhase"; paramValue: sync(boxGrower.name+".grow.scaVarPhase") }
                ShaderParam { paramName: "g_branchMove"; paramValueVec4: sync(boxGrower.name+".grow.move")*0.10+","+sync(boxGrower.name+".grow.moveX")*0.10+","+sync(boxGrower.name+".grow.moveY")*0.10+","+sync(boxGrower.name+".grow.moveZ")*0.10 }
                ShaderParam { paramName: "g_branchMovePal"; paramValueVec4: sync(boxGrower.name+".grow.movePalAmp")+","+sync(boxGrower.name+".grow.movePalAge")+","+sync(boxGrower.name+".grow.moveY")+","+sync(boxGrower.name+".grow.moveZ") }
                ShaderParam { paramName: "g_branchMovePalFreqOfs"; paramValueVec4: sync(boxGrower.name+".grow.movePalFreq")+","+sync(boxGrower.name+".grow.movePalFreqLevel")+","+sync(boxGrower.name+".grow.movePalOfs")+","+sync(boxGrower.name+".grow.movePalOfsLevel") }
                ShaderParam { paramName: "g_branchMovePerLevel"; paramValue: sync(boxGrower.name+".grow.movePerLevel")*0.10 }
                ShaderParam { paramName: "g_branchMoveMulLevel"; paramValue: sync(boxGrower.name+".grow.moveMulLevel") }
                ShaderParam { paramName: "g_branchMoveOfs"; paramValue: sync(boxGrower.name+".grow.moveOfs")*0.10 }
                ShaderParam { paramName: "g_branchMoveOfsPerLevel"; paramValue: sync(boxGrower.name+".grow.moveOfsPerLevel")*0.10 }
                ShaderParam { paramName: "g_branchScalePerLevel"; paramValue: sync(boxGrower.name+".grow.scalePerLevel") }
                ShaderParam { paramName: "g_emitRateMS"; paramValue: sync(boxGrower.name+".grow.emitRateMS") }
                ShaderParam { paramName: "g_branchRot1"; paramValue: sync(boxGrower.name+".grow.rot1") }
                ShaderParam { paramName: "g_branchRot2"; paramValue: sync(boxGrower.name+".grow.rot2") }
                ShaderParam { paramName: "g_branchRot1Level"; paramValue: sync(boxGrower.name+".grow.rot1Level") }
                ShaderParam { paramName: "g_branchRot2Level"; paramValue: sync(boxGrower.name+".grow.rot2Level") }
                ShaderParam { paramName: "g_branchAngle"; paramValueVec4: sync(boxGrower.name+".grow.branchAng")+","+sync(boxGrower.name+".grow.branchAngVar")+","+sync(boxGrower.name+".grow.branchAngVarFreq") }
                ShaderParam { paramName: "g_rotAmount"; paramValue: sync(boxGrower.name+".grow.rotAmount") }
                ShaderParam { paramName: "g_rotAmountLevel"; paramValue: sync(boxGrower.name+".grow.rotAmountLevel") }
                ShaderParam { paramName: "g_maxSca"; paramValue: sync(boxGrower.name+".grow.maxSca") }
                ShaderParam { paramName: "g_maxScaSmooth"; paramValue: sync(boxGrower.name+".grow.maxScaSmooth") }
                ShaderParam { paramName: "g_scaleMove"; paramValue: sync(boxGrower.name+".grow.moveScale") }
                ShaderParam { paramName: "g_maxScaMove"; paramValue: sync(boxGrower.name+".grow.maxScaMove") }
                ShaderParam { paramName: "g_maxScaMoveSmooth"; paramValue: sync(boxGrower.name+".grow.maxScaMoveSmooth") }
                ShaderParam { paramName: "g_dirDiscreet"; paramValue: sync(boxGrower.name+".grow.dirDiscreet") }

            }

            drawShader: "branchDrawInt";
            drawParams: ParamGroup {
                Pos { x: 0.0; y: 0.0; z: 0.0 }
                Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
                Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
                ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen") }
                ShaderParam { paramName: "g_discardEdgeFade"; paramValue: 1.0-sync(boxGrower.name+".grow.discEdgeFade") }
                ShaderParam { paramName: "g_discardEdgeFadeSpeed"; paramValue: sync(boxGrower.name+".grow.discEdgeFadeSpeed") }
                ShaderParam { paramName: "g_bump"; paramValue: 1.0}
                ShaderParam { paramName: "g_texBrightness"; paramValue: 0.50 }
                ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
                ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
                ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }
                ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.1*sync("prevBlurAmount") }
                ShaderParam { paramName: "g_bright"; paramValue: 1.0}
                ShaderParam { paramName: "g_palSwipeFreq"; paramValue: sync(boxGrower.name+".swipe.freq") }
                ShaderParam { paramName: "g_palSwipeOfs"; paramValue: sync(boxGrower.name+".swipe.ofs")+boxGrowerSwipeTime.time }
                ShaderParam { paramName: "g_palSwipeZero"; paramValue: sync(boxGrower.name+".swipe.zeroColor")}
                ShaderParam { paramName: "g_palSwipeIntensity"; paramValue: sync(boxGrower.name+".swipe.colIntensity")}
                ShaderParam { paramName: "g_palSwipeColorPow"; paramValue: sync(boxGrower.name+".swipe.colPow")}
                ShaderParam { paramName: "g_palSwipeFadeFreq"; paramValue: sync(boxGrower.name+".swipe.fadeFreq")}
                ShaderParam { paramName: "g_palSwipeFadeOfs"; paramValue: sync(boxGrower.name+".swipe.fadeOfs")+boxGrowerSwipeFadeTime.time}
                ShaderParam { paramName: "g_palSwipeFadePerc"; paramValue: sync(boxGrower.name+".swipe.fadeCutoff")}
                ShaderParam { paramName: "g_palSwipeTimeOfs"; paramValue: boxSwipeFadeTrigger.time }
                ShaderParam { paramName: "g_swipeRadAmp"; paramValue: sync(boxGrower.name+".swipe.radAmp") }

                ShaderParam { paramName: "g_agePalFreq"; paramValue: sync(boxGrower.name+".agePal.freq") }
                ShaderParam { paramName: "g_agePalOfs"; paramValue: sync(boxGrower.name+".agePal.ofs") }
                ShaderParam { paramName: "g_agePalIntensity"; paramValue: sync(boxGrower.name+".agePal.intensity") }

                ShaderParam { paramName: "g_texFade0"; paramValue: boxGrowerTex0.texFade; }
                // ShaderParam { paramName: "g_swipe0TexFade"; paramValue: boxGrowerSwipe0.texFade; }
                // ShaderParam { paramName: "g_swipe1TexFade"; paramValue: boxGrowerSwipe1.texFade; }

            }

            drawMesh: DrawMesh {
                // draw one bigger mesh
                file: drawTransBG.file; Pos { x: drawTransBG.er*Math.sin(drawTransBG.ki)+drawTransBG.pr*Math.cos(drawTransBG.kii*2.3); y: Math.abs(0.0*(Math.sin(drawTransBG.ki*0.9+Math.cos(drawTransBG.kii*1.5)))); z: drawTransBG.er*Math.cos(drawTransBG.ki)+drawTransBG.pr*Math.sin(drawTransBG.kii*3.43)}
                halfFloats: drawTransBG.transPack
                intPack: drawTransBG.transPack
                Rot { d: 0.0; ax: 1.0; ay: 1.0; az: 0.0 }
                // Pos { x: 10.0 }
                Sca { s: sync(boxGrower.name+".grow.emitMeshScale"); x: 1.0; y: 1.0; z: 1.0 }
                ShaderParam { paramName: "g_emit"; paramValue: 1.0}
                ShaderParam { paramName: "g_bright"; paramValue: drawTransBG.drawIndex%2 < 1 ? 1.0 : 1.0 }
                ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
                blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true
                cullBack: true
                cull: true
                property real kic: drawTransBG.ki
            }
        }
    }

    Credits { }
    Credits { name: "credits2" }

    Blit { textureRT: "depth"; blitRT: 1}


    DustPartikles {
        name: "dustPart"
        TextureSel { id: partikleTex; name: parent.name }
        partTexture: partikleTex.file
        drawBlendMode: blendSel(name)


        emitMesh: MeshSel {
            id: meshSel;
            name: parent.name;

            depthTest: false; depthWrite: false; blendMode: "off"

            // Shader params for particle emitting
            ShaderParam { paramName: "g_emitPercent"; paramValue: sync(name+".g_emitPercent"); }

            // Shader params for mesh surface
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.20 }
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }

            Pos { x: sync(name+".emitMeshPosX"); y: sync(name+".emitMeshPosY"); z: sync(name+".emitMeshPosZ"); }
            Rot { d: sync(name+".emitMeshRotY"); ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: sync(name+".emitMeshRotX"); ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: sync("dustPart.g_emitterSize"); x: 1.0; y: 1.0; z: 1.0 }
        }
    }

    SpaceVortex {
        id: spaceVortex
        name: "vortex"

        // textureVortexPlane: "../../images/palette_shot8.png"
        // textureAgeSwipe: "../../images/palette_shot8.png"

//        TextureSel { id: spaceVortexPlaneTex; textureUnit: 0; name: parent.name}
//        textureVortexPlane: spaceVortexPlaneTex.file

//        TextureSel { id: spaceVortexAgeSwipeTex; textureUnit: 1; name: parent.name}
//        textureAgeSwipe: spaceVortexAgeSwipeTex.file

//        TextureSel { id: spaceVortexDrawTex; textureUnit: 2; name: parent.name}
//        textureDraw: spaceVortexDrawTex.file

      //  MeshSel { id: spaceVortexMeshSel; enabled: false; name: parent.name}
      //  file: spaceVortexMeshSel.file // "box1m.lwo"
        file: "mesh/box1m.lwo"

        // do not modify this dynamically on fly during the demo
        maxParticles: 1000000

        blendMode: blendSel(name) // "add"

        property int simShaderSel: sync(spaceVortex.name+".simShader")
        simShader: {
            if (simShaderSel === 0) return "simVortex";
            if (simShaderSel === 1) return "simVortex";
            return "simVortex";
        }

        property int drawShaderSel: sync(spaceVortex.name+".drawShader")
        drawShader:  {
            if (drawShaderSel === 0) return "partVortex";
            if (drawShaderSel === 1) return "partEndos";
            return "partVortex";
        }

        meshParams: ParamGroup {
            Pos { x: 0.0; y: -1.40; z: 0.0}
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 10.0; x: 100.0; y: 0.05; z: 100.0 }
        }
        mesh2Params: ParamGroup {
            Pos { x: 0.0; y: -1.40; z: 0.0}
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 10.0; x: 100.0; y: 0.05; z: 100.0 }
        }
    }



    PrevBlur {
        id: pb
        Connections {
            function clamp(v) {
                return Math.max(Math.min(v, 1.0), -1.0);
            }
            property real prevTi: 0.0
            target: demo; onFrameRendered: {
                var camAutoEnabled = sync("camera.autoMove.ON");
                var ti = demoTime();
                var deltaTime = (ti-prevTi);
                prevTi = ti;
                if (camAutoEnabled && deltaTime > 0.0) {
                    flyCam.camOfs.x += (-pb.getAvgPosX())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accX")), rocket.timeStepReal/16.67);
                    flyCam.camOfs.y += (-pb.getAvgPosY())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accY")), rocket.timeStepReal/16.67);
                    flyCam.camOfs.z += (-pb.getAvgPosZ())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accZ")), rocket.timeStepReal/16.67);
                }
                var k = Math.pow(0.95, rocket.timeStepReal/16.67);
                flyCam.camOfs.x *= k;
                flyCam.camOfs.y *= k;
                flyCam.camOfs.z *= k;

                // console.log("x:"+pb.getAvgPosX(), "y:"+pb.getAvgPosY(), "z:"+pb.getAvgPosZ());
            }
        }
    }


    // postprocs
    Reflect { }


    GodRay {
        property int centrumSel: sync("godray.meshIndex")
        property string centrum: {
            // ball
            if (centrumSel === 0) return "centrum";

            // box
            if (centrumSel === 1) return "centrumBox";

            // default to not follow any mesh
            return "";
        }

        godRayX: centrum !== "" ? getSavePointX2D(centrum) : 0.0
        godRayY: centrum !== "" ? getSavePointY2D(centrum) : 0.0
    }

    Fog {
        textureBG: "bgBall"
    }
    Tonemap { }
    Glow { }

    Overlay { name: "ovl0" }
    Overlay { name: "ovl1" }
    Overlay { name: "ovl2" }



    Blit { textureRT: "prev" }
    Vignette { }

    Overlay { name: "ovlFin0" }
    Overlay { name: "ovlFin1" }
    Overlay { name: "ovlFin2" }


    Coords { }
}
